(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32000,        902]*)
(*NotebookOutlinePosition[     32724,        927]*)
(*  CellTagsIndexPosition[     32680,        923]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(<< Graphics`Master`;\)\)], "Input"],

Cell[TextData[{
  StyleBox["Ejercicio 1",
    FontWeight->"Bold"],
  ". Calcular el volumen del s\[OAcute]lido limitado superiormente por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = 2  x\  + 1\),
          FontWeight->"Bold"], TraditionalForm]]],
  " e inferiormente por el conjunto",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          StyleBox[\({\((x, 
                  y)\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : \ 
                  x\^2 + \((y - 1)\)\^2 \[LessEqual] 1\)}\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Soluci\[OAcute]n",
    FontWeight->"Bold"],
  ". Se trata del corte de un ciindro circular recto con un plano. Como nos \
dicen que ",
  Cell[BoxData[
      \(TraditionalForm\`z \[GreaterEqual] 0\)],
    FontWeight->"Bold"],
  " debe ser",
  StyleBox[" ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x \[GreaterEqual] \(-1\)/2\)],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[BoxData[{
    \(\(G1 = 
        ParametricPlot3D[{{x, 1 + \@\(\(1\)\(-\)\(x\^2\)\(\ \)\), 
              3  z/2}, {x, 1 - \@\(\(1\)\(-\)\(x\^2\)\(\ \)\), 3  z/2}, {x, 
              3  z/2, 2  x + 1}}, {x, \(-1\)/2, 1}, {z, 0, 2}, 
          PlotRange \[Rule] {{\(-1\)/2, 1}, {0, 2}, {0, 3}}, 
          ViewPoint -> {\(-2.460\), \ \(-1.792\), \ 1.479}, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(G2 = 
        ParametricPlot3D[{{x, 1 + \@\(\(1\)\(-\)\(x\^2\)\(\ \)\), 
              Min[3  z/2, 2  x + 1]}, {x, 1 - \@\(\(1\)\(-\)\(x\^2\)\(\ \)\), 
              Min[3  z/2, 2  x + 1]}}, {x, \(-1\)/2, 1}, {z, 0, 2}, 
          PlotRange \[Rule] {{\(-1\)/2, 1}, {0, 2}, {0, 3}}, 
          ViewPoint -> {\(-2.460\), \ \(-1.792\), \ 1.479}, 
          DisplayFunction \[Rule] Identity];\)\), "\n", 
    \(\(G3 = 
        Show[{Plot3D[2  x + 1, {x, \(-1\)/2, 1}, {y, 0, 2}, 
              DisplayFunction \[Rule] Identity], 
            ParametricPlot3D[{Cos[t], 1 + Sin[t], 
                Min[z, 2  Cos[t] + 
                    1\ \  +  .2]}, {t, \(-\[Pi]\) +  .35, \[Pi] -  .35}, {z, 
                0, 3}, PlotPoints \[Rule] 40, 
              DisplayFunction \[Rule] Identity]}, 
          DisplayFunction \[Rule] Identity, 
          PlotRange \[Rule] {{\(-1\)/2, 1}, {0, 2}, {0, 3}}, 
          BoxRatios \[Rule] {1, 1, 1.5}, 
          ViewPoint -> {\(-2.460\), \ \(-1.792\), \ 
              1.479}];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{G1, G2, G3}, GraphicsSpacing \[Rule]  .25], 
        ImageSize \[Rule] {627, 219}];\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      2  x + 1, {x, \(-1\)/2, 1}, {y, 1 - \@\(1 - x\^2\), 
        1 + \@\(1 - x\^2\)}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(3\ \@3\)\/4 + \(2\ \[Pi]\)\/3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Podemos calcular el volumen por secciones perpendiculares al eje OZ. \
Observa que dichas secciones son sectores circulares, concretamente son los \
conjuntos ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          StyleBox[\({\((x, 
                  y)\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : \ 
                  x\^2 + \((y - 1)\)\^2 \[LessEqual] 1\)\ , \ \((z - 1)\)/
                  2 \[LessEqual] x \[LessEqual] 1}\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(0 \[LessEqual] z \[LessEqual] 3\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      FullSimplify[2\ Integrate[\@\(1 - x\^2\), {x, \((z - 1)\)/2, 1}]], {z, 
        0, 3}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(3\ \@3\)\/4 + \(2\ \[Pi]\)\/3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Ejercicio 2.",
    FontWeight->"Bold"],
  " Calcular el volumen del s\[OAcute]lido limitado superiormente por ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = x + y\),
          FontWeight->"Bold"], TraditionalForm]]],
  " e inferiormente por el tri\[AAcute]ngulo de v\[EAcute]rtices (0,0) \
,(0,1), (1,0)."
}], "Text"],

Cell[TextData[{
  StyleBox["Soluci\[OAcute]n",
    FontWeight->"Bold"],
  ". Se trata de una pir\[AAcute]mide"
}], "Text"],

Cell[BoxData[
    \(\(ParametricPlot3D[{{x, 1 - Min[x + y, 1], 0}, {1 - x, 0, 
            1 - x - y}, {0, 1 - y, 1 - x - y}, {x, y, x + y}}, {x, 0, 1}, {y, 
          0, 1}, PlotRange \[Rule] {{0, 1}, {0, 1}, {0, 1}}, 
        ViewPoint -> {2.650, \ 1.865, \ 0.975}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[x + y, {x, 0, 1}, {y, 0, 1 - x}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1\/3\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Que es el volumen de una pir\[AAcute]mide cuya altura es ",
  Cell[BoxData[
      \(TraditionalForm\`\@2/2\)]],
  " y base rectangular de lados iguales a ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  " y a 1."
}], "Text"],

Cell[TextData[{
  StyleBox["Ejercicio 3",
    FontWeight->"Bold"],
  ". Calcular el volumen del s\[OAcute]lido comprendido por el paraboloide de \
ecuaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = x\^2 + y\^2\),
          FontWeight->"Bold"], TraditionalForm]]],
  " e inferiormente por el disco unidad."
}], "Text"],

Cell[BoxData[
    \(\(Show[{ParametricPlot3D[{Cos[t], Sin[t], z}, {t, \(-\[Pi]\)/7, 
              9  \[Pi]/7}, {z, 0, 1}, DisplayFunction \[Rule] Identity], 
          SurfaceOfRevolution[x\^2, {x, 0, 1}, {t, \(-\[Pi]\), \[Pi]}, 
            RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
            AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction, 
        ViewPoint -> {0.193, \ \(-3.271\), \ 0.845}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      x\^2 + y\^2, {x, \(-1\), 
        1}, {y, \(-\@\(1 - x\^2\)\), \@\(1 - x\^2\)}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\[Pi]\/2\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " calcula con facilidad esa integral pero nosotros haremos bien en \
calcularla en polares que es mucho m\[AAcute]s f\[AAcute]cil."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\[Rho]\^3, {\[Theta], \(-\[Pi]\), \[Pi]}, {\[Rho], 0, 
        1}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\[Pi]\/2\)], "Output"]
}, Open  ]],

Cell["\<\
Observa lo que ocurre si hacemos directamente las integrales iteradas sin \
pasar a coordenadas polares.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      x\^2 + y\^2, {y, \(-\@\(1 - x\^2\)\), \@\(1 - x\^2\)}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`2\ \@\(1 - x\^2\)\ x\^2 + 
      2\/3\ \((1 - x\^2)\)\^\(3/2\)\)], "Output"]
}, Open  ]],

Cell["\<\
Ahora hay que integrar esa expresi\[OAcute]n. Se impone un cambio de \
variable.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullSimplify[% /. x \[Rule] Sin[t], \(-\[Pi]\)/2 < t < \[Pi]/2]*
      Cos[t]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(cos(
        t)\)\ \((cos(t) - 1\/3\ \(cos(3\ t)\))\)\)], "Output"]
}, Open  ]],

Cell["\<\
Ahora ya podemos integrar con faclidad. No hay que olvidar que los \
l\[IAcute]mites de integraci\[OAcute]n han cambiado.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[%, {t, \(-\[Pi]\)/2, \[Pi]/2}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\[Pi]\/2\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Ejercicio 4",
    FontWeight->"Bold"],
  ". Calcular el volumen del s\[OAcute]lido limitado superiormente por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"z", "=", 
          RowBox[{"4", "-", \(y\^2\), "-", 
            StyleBox[\(x\^2\/4\),
              FontSize->18]}]}], TraditionalForm]],
    FontWeight->"Bold"],
  " e inferiormente por el disco ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          
          StyleBox[\({\((x, 
                  y)\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : \ 
                  x\^2 + \((y - 1)\)\^2 \[LessEqual] 1\)}\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[{Plot3D[4 - y\^2 - x\^2/4, {x, \(-1\), 1}, {y, 0, 2}, 
            DisplayFunction \[Rule] Identity], 
          ParametricPlot3D[{Cos[t], 1 + Sin[t], 
              Min[z, 4 - \((1 + Sin[t])\)\^2 - \ 
                  Cos[t]\^2/4\ \  +  .1]}, {t, \(-\[Pi]\), \[Pi]}, {z, 0, 4}, 
            DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction, 
        ViewPoint -> {2.800, \ \(-0.209\), \ 1.889}];\)\)], "Input"],

Cell[BoxData[
    \(<< Calculus`Integration`\)], "Input"],

Cell[BoxData[
    \(\(Plot3D[\((4 - y\^2 - x\^2/4)\)\ Boole[\ 
            x\^2 + \((y - 1)\)\^2 \[LessEqual] 1], \ {x, \ \(-1.2\), \ 
          1.2}, \ {y, \ \(- .2\), \ 2.3}, 
        ViewPoint -> {2.485, \ 1.525, \ 1.718}\ , \ PlotPoints \[Rule] 200, \ 
        Boxed \[Rule] False, Axes \[Rule] False, 
        Mesh \[Rule] False];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      4 - y\^2 - x\^2/4, {x, \(-1\), 1}, {y, 1 - \@\(1 - x\^2\), 
        1 + \@\(1 - x\^2\)}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(43\ \[Pi]\)\/16\)], "Output"]
}, Open  ]],

Cell["Naturalmente, lo apropiado es pasar a polares.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((\((4 - y\^2 - 
                x\^2/4)\) /. {x \[Rule] \[Rho]\ Cos[\[Theta]], 
              y \[Rule] \[Rho]\ Sin[\[Theta]]})\)*\[Rho], {\[Theta], 
        0, \[Pi]}, {\[Rho], 0, 2\ Sin[\[Theta]]}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(43\ \[Pi]\)\/16\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Ejercicio 5",
    FontWeight->"Bold"],
  ". Calcular el volumen del conjunto ",
  StyleBox["{",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{\((x, y, x)\), " ", "\[Element]", " ", 
            
            FormBox[\(\(\[DoubleStruckCapitalR]\^3\) : \ 
                0 \[LessEqual] z \[LessEqual] x\^2 + y\^2 \[LessEqual] \ 
                  2  x\),
              "TraditionalForm"]}],
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox["}",
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Soluci\[OAcute]n",
    FontWeight->"Bold"],
  ". Se trata de la regi\[OAcute]n bajo el paraboloide ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(z = x\^2 + y\^2\),
          FontWeight->"Bold"], TraditionalForm]]],
  " e interior al cilindro circular recto de base ",
  Cell[BoxData[
      RowBox[{" ", Cell[TextData[Cell[BoxData[
            FormBox[
              StyleBox[\(y\^2 + \((x - 1)\)\^2 \[LessEqual] 1\),
                FontWeight->"Bold"], TraditionalForm]]]]]}]]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[{ParametricPlot3D[{1 + Cos[t], Sin[t], 
              Min[z, \((1 + Cos[t])\)\^2 + Sin[t]\^2 +  .1]}, {t, \(-\[Pi]\)/
                7, 10  \[Pi]/7}, {z, 0, 4}, PlotPoints \[Rule] 50, 
            DisplayFunction \[Rule] Identity], 
          SurfaceOfRevolution[
            x\^2, {x, 0, 2}, {t, \(-2\) \[Pi]/9, 3  \[Pi]/2}, 
            RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
            Axes \[Rule] False, Boxed \[Rule] False, 
            DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction, 
        ViewPoint -> {0.193, \ \(-3.271\), \ 0.845}];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      x\^2 + y\^2, {y, \(-1\), 1}, {x, 1 - \@\(\(1\)\(-\)\(y\^2\)\(\ \)\), 
        1 + \@\(1 - y\^2\)}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(3\ \[Pi]\)\/2\)], "Output"]
}, Open  ]],

Cell["En coordendas polares el c\[AAcute]lculo es m\[AAcute]s sencillo.", \
"Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\[Rho]\^3, {\[Theta], \(-\[Pi]\)/2, \[Pi]/2}, {\[Rho], 0, 
        2  Cos[\[Theta]]}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(3\ \[Pi]\)\/2\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Ejercicio 6",
    FontWeight->"Bold"],
  ". Calcular el volumen del conjunto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(A = {\((x, y, 
                  z)\) \[Element] \(\(\[DoubleStruckCapitalR]\^3\) : 
                  x\^2 + y\^2 \[LessEqual] \ 
                    z \[LessEqual] \ \@\(x\^2 + y\^2\)\)}\),
          FontWeight->"Bold"], TraditionalForm]]]
}], "Text"],

Cell[TextData[{
  "Como ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x\^2 + y\^2 \[LessEqual] \ 
            z \[LessEqual] \ \@\(x\^2 + y\^2\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " deber\[AAcute] ser ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\(\[LessEqual]\)\(1\)\)\)\)],
    FontWeight->"Bold"],
  ", y en consecuencia tendremos que  ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] z \[LessEqual] 1\)],
    FontWeight->"Bold"],
  ". Dibujemos los gr\[AAcute]ficos de las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f(x, y)\)\(=\)\)\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2\)],
    FontWeight->"Bold"],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(g(x, y)\)\(=\)\)\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\@\(x\^2 + y\^2\)\)],
    FontWeight->"Bold"],
  StyleBox[".",
    FontWeight->"Bold"]
}], "Text"],

Cell[BoxData[{
    \(Clear[f, g]\), "\[IndentingNewLine]", 
    \(f[x_, y_] = x\^2 + y\^2; \ g[x_, y_] = \@\(x\^2 + y\^2\);\)}], "Input"],

Cell[BoxData[{
    \(\(graf2 = 
        Plot3D[Min[f[x, y], 1], {x, \(-1.2\), 1.2}, {y, \(-1.2\), 1.2}, 
          AspectRatio \[Rule] 1, PlotPoints \[Rule] 50, Mesh -> False, 
          ViewPoint -> {2.090, \ \(-2.564\), \ 0.713}, PlotRange \[Rule] All, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(graf3 = 
        Plot3D[Min[g[x, y], 1], {x, \(-1.2\), 1.2}, {y, \(-1.2\), 1.2}, 
          AspectRatio \[Rule] 1, PlotPoints \[Rule] 50, Mesh -> False, 
          ViewPoint -> {2.090, \ \(-2.564\), \ 0.713}, PlotRange \[Rule] All, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[GraphicsArray[{graf2, graf3}]];\)\)}], "Input"],

Cell[TextData[{
  "Como puedes ver se trata de un paraboloide de revoluci\[OAcute]n. El que \
se engendra al girar la par\[AAcute]bola ",
  Cell[BoxData[
      \(TraditionalForm\`z = x\^2\)]],
  "alrededor del eje OZ y",
  StyleBox[" de un cono circular recto engendrado al girar la recta ",
    FontSize->14],
  Cell[BoxData[
      \(TraditionalForm\`z = x\)],
    FontSize->14],
  StyleBox[" alrededor del eje OZ. Si le pedimos a ",
    FontSize->14],
  StyleBox["Mathematica",
    FontSize->14,
    FontSlant->"Italic"],
  StyleBox[" que nos ense\[NTilde]e las dos gr\[AAcute]ficas juntas estamos \
perdiendo el tiempo porque, al quedar el cono en el interior del paraboloide \
s\[OAcute]lo veremos a \[EAcute]ste. Pero s\[IAcute] es posible mostrar las \
dos superficies usando el comando \"SurfaceOfRevolution\" para lo que antes \
hay que cargar el correspondiente paquete.",
    FontSize->14]
}], "Text"],

Cell[BoxData[
    \(\(Show[{SurfaceOfRevolution[x, {x, 0, 1}, 
            RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
            AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, DisplayFunction \[Rule] Identity], 
          SurfaceOfRevolution[x\^2, {x, 0, 1}, {t, 0, \[Pi]}, 
            RevolutionAxis \[Rule] {0, 0, 1}, PlotPoints \[Rule] 50, 
            AspectRatio \[Rule] Automatic, Axes \[Rule] False, 
            Boxed \[Rule] False, DisplayFunction \[Rule] Identity]}, 
        DisplayFunction \[Rule] $DisplayFunction, 
        ViewPoint -> {\(-0.012\), \ \(-3.382\), \ 0.109}];\)\)], "Input"],

Cell[TextData[{
  StyleBox["Con lo ya visto es suficiente para calcular el volumen de la regi\
\[OAcute]n comprendida entre el paraboloide y el cono.  La proyecci\[OAcute]n \
del conjunto A sobre el plano XY es el disco unidad, D((0,0),1). Para cada \
(x,y)\[Element]D((0,0),1), se tiene que ",
    FontSize->14],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 \[LessEqual] \ 
        z \[LessEqual] \ \@\(x\^2 + y\^2\)\)],
    FontSize->14],
  StyleBox[". En consecuencia, el volumen de A, \[Lambda](A),podemos \
obtenerlo calculando el volumen del \"cilindro\" con base el disco unidad y \
tapadera el cono y rest\[AAcute]ndole el volumen del \"cilindro\" con la \
misma base y tapadera el paraboloide. Es decir, se trata de integrar la funci\
\[OAcute]n ",
    FontSize->14],
  Cell[BoxData[
      \(\@\(x\^2 + y\^2\) - x\^2 - y\^2\)],
    FontSize->14],
  StyleBox[" en el disco unidad. Hag\[AAcute]moslo. Por supuesto, las \
coordenadas polares on las apropiadas en este caso.",
    FontSize->14]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\((\[Rho] - \[Rho]\^2)\)*\[Rho], {\[Theta], \(-\[Pi]\), \
\[Pi]}, {\[Rho], 0, 1}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\[Pi]\/6\)], "Output"]
}, Open  ]],

Cell[TextData[StyleBox["Observa lo que ocurre si intentas calcular la \
integral en coordenadas cartesianas.",
  FontSize->14]], "Text"],

Cell[BoxData[{
    \(Clear[f]\), "\[IndentingNewLine]", 
    \(\(f[x_, y_] = \@\(x\^2 + y\^2\) - x\^2 - y\^2;\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      f[x, y], {x, \(-1\), 
        1}, {y, \(-\@\(1 - x\^2\)\), \@\(1 - x\^2\)}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`1\/6\ \(\[Integral]\_\(-1\)\%1\((\(-3\)\ \(log(
                  1 - \@\(1 - x\^2\))\)\ x\^2 + 
              3\ \(log(\@\(1 - x\^2\) + 1)\)\ x\^2 - 
              8\ \@\(1 - x\^2\)\ x\^2 + 
              2\ \@\(1 - x\^2\))\) \[DifferentialD]x\)\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["F\[IAcute]jate que Mathematica ha calculado la integral en la \
variable \"y\" pero, aparentemente, no sabe integrar respecto a \"x\" el \
resultado obtenido. Aveces, en estos casos, con un poco de ayuda, Mathematica \
puede hacer el c\[AAcute]lculo que nos interesa pero no hay garant\[IAcute]a \
de \[EAcute]xito. Por ejemplo, podemos intenta hacer en la integral anterior \
el cambio ",
    FontSize->14],
  Cell[BoxData[
      FormBox[
        StyleBox[\(x = \ Sin[t]\),
          FontSize->14], TraditionalForm]]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[
      FullSimplify[
        Integrate[f[x, y], {y, \(-\@\(1 - x\^2\)\), \@\(1 - x\^2\)}]*Cos[t] /. 
          x \[Rule] Sin[t], \(-\[Pi]\)/2 < t < \[Pi]/2], {t, \(-\[Pi]\)/
          2, \[Pi]/2}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\[Pi]\/6\)], "Output"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Ejercicio 7",
    FontWeight->"Bold"],
  ". Calcular el volumen del conjunto ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{"A", "=", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{\((x, y, z)\), "\[Element]", 
                  RowBox[{\(\[DoubleStruckCapitalR]\^3\), ":", 
                    RowBox[{
                      StyleBox[\(x\^2\/a\^2 + y\^2\/b\^2\),
                        FontSize->18], 
                      StyleBox["\[LessEqual]",
                        FontSize->16], 
                      StyleBox[" ",
                        FontSize->16], 
                      StyleBox["1",
                        FontSize->16]}]}]}], " ", ",", " ", 
                RowBox[{"0", "\[LessEqual]", "z", "\[LessEqual]", " ", 
                  SqrtBox[
                    StyleBox[\(x\^2\/a\^2 + y\^2\/b\^2\),
                      FontSize->18]]}]}], " ", "}"}]}],
          FontWeight->"Bold"], TraditionalForm]]]
}], "Text"],

Cell[BoxData[
    \(\(Plot3D[
        Min[\@\(x\^2\/4 + y\^2\/9\), 1], {x, \(-2.2\), 2.2}, {y, \(-3.2\), 
          3.2}, AspectRatio \[Rule] 1, PlotPoints \[Rule] 50, Mesh -> False, 
        ViewPoint -> {2.090, \ \(-2.564\), \ 0.713}, 
        PlotRange \[Rule] All];\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[\[Rho]\^2*a\ *
        b*\[Rho], {\[Theta], \(-\[Pi]\), \[Pi]}, {\[Rho], 0, 1}]\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`\(a\ b\ \[Pi]\)\/2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "C\[AAcute]lculo de una integral triple con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    RowBox[{
    "Te", " ", "propongo", " ", "que", " ", "calcules", " ", "la", " ", 
      "integral", 
      FormBox[\(\(\(\[Integral]\(\[Integral]\[Integral]\)\)\+A\) \(x\^2\) \
\[DifferentialD]\((x, y, z)\)\),
        "TraditionalForm"], " ", "donde", " ", "A", " ", "es", " ", "el", " ",
       "conjunto", 
      RowBox[{
        StyleBox[
          
          FormBox[\(A = {\((x, y, z)\) : 
                  x\^2 + y\^2 + \((z - 1)\)\^2 \[LessEqual] 1, \ 
                3\ z\^2 \[GreaterEqual] \ x\^2 + y\^2}\),
            "TraditionalForm"],
          FontWeight->"Bold"], ".", " "}]}]], "Text",
  FontFamily->"Times New Roman"],

Cell[TextData[{
  "Representa gr\[AAcute]ficamente el conjunto A. Para ello sigue los \
siguientes pasos:\nCalcula la intersecci\[OAcute]n de la esfera  ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + \((z - 1)\)\^2 = 1\)]],
  " con el cono ",
  Cell[BoxData[
      \(TraditionalForm\`3\ z\^2 = \ x\^2 + y\^2\)]],
  "."
}], "Text",
  FontFamily->"Times New Roman"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[{1/3\ \((x\^2 + y\^2)\), 
          x\^2 + y\^2 + \((z - 1)\)\^2} \[Equal] {\(\(z\)\(\ \)\)\^2, 
          1}]\)], "Input",
  FontFamily->"Courier New"],

Cell[BoxData[
    \(TraditionalForm\`x == \(-\[ImaginaryI]\)\ y \[And] z == 0 \[Or] 
      x == \[ImaginaryI]\ y \[And] z == 0 \[Or] 
      x == \(-\(\@\(3\/2 - 2\ y\^2\)\/\@2\)\) \[And] z == 1\/2 \[Or] 
      x == \@\(3\/2 - 2\ y\^2\)\/\@2 \[And] z == 1\/2\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Este\ resultado\ nos\ dice\ que\ la\ intersecci\[OAcute]n\ de\ la\ \
esfera\ y\ el\ cono\ es\ el\ conjunto\ de\ puntos\ de\ la\ forma\ \((x, y, 
            1/2)\)\ \ donde\ 2  x\^2 + 2  y\^2 = 3/2; \ es\ decir, \ 
    la\ circunferencia\ situada\ en\ el\ plano\ z = 1/2, \ 
    centrada\ en\ \((0, 0, 1/2)\), \ 
    de\ radio\ \(\(\@3\)\(/\)\(2.\)\(\ \ \)\)\)], "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
Como puedes adivinar, se trata de un helado: un cono tapado por un casuqte \
esf\[EAcute]rico. Para facilitar la representaci\[OAcute]n voy a inventarme \
unos datos.\
\>", "Text"],

Cell[BoxData[{
    \(\(Clear[graf1, graf2];\)\), "\[IndentingNewLine]", 
    \(a = 2\ Cos[Pi/12]; \ b = 2 + 2  Sin[Pi/12];\), "\n", 
    \(\(c = b/a;\)\), "\n", 
    \(\(r = \((Pi/2\  - \ Pi/12)\)/a;\)\), "\[IndentingNewLine]", 
    \(\(graf1 = 
        SurfaceOfRevolution[{2\ Cos[Pi/12\  + \ r\ u\ ], 
            2\  + \ 2\ Sin[Pi/12\ \  + r\ u]}, {u, 0, a}, {t, 0, 2  \[Pi]}, 
          AspectRatio \[Rule] Automatic, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(graf2 = 
        SurfaceOfRevolution[{u, c\ u}, {u, 0, a}, {t, 0, 2  \[Pi]}, 
          AspectRatio \[Rule] Automatic, 
          DisplayFunction \[Rule] Identity];\)\), "\[IndentingNewLine]", 
    \(\(Show[graf1, graf2, ViewPoint -> {2.880, \ 1.654, \ 0.647}, 
        DisplayFunction \[Rule] $DisplayFunction];\)\)}], "Input"],

Cell[BoxData[
    \(Calcula\ ahora\ la\ integral\ integrando\ por\ secciones\ paralelas\ al\
\ plano\ XY\ \ F\[IAcute]jate\ que\ si\ 0 \[LessEqual] z \[LessEqual] 
        1/2\ entonces\ \ A\_\(\(z\)\(\ \)\) = \({\((x, 
            y)\), \((x, y, z)\) \[Epsilon]\ A} = {\((x, y)\) : \ 
            x\^2 + y\^2 \[LessEqual] 3  z\^2}\); \ 
    y\ \ si\ \ 1/2 \[LessEqual] z \[LessEqual] 2, \ 
    A\_\(\(z\)\(\ \)\) = \({\((x, 
            y)\), \((x, y, z)\) \[Epsilon]\ A} = \({\((x, y)\) : \ 
              x\^2 + y\^2 \[LessEqual] 
                1 - \((z - 1)\)\^2} = {\((x, y)\) : \ 
                  x\^2 + y\^2 \[LessEqual] 
                    2  z - z\^2} . \[IndentingNewLine]La\ integral\ podemos\ \
calcularla\ en\ la\ forma\)\)\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(\(\[Integral]\(\[Integral]\[Integral]\)\)\+A\) \(x\^2\) \
\[DifferentialD]\((x, y, 
            z)\) = \[Integral]\_0\%\(1/2\)\([\(\(\[Integral]\[Integral]\)\+\(\
A\_z\)\) \(x\^2\) \[DifferentialD]\((x, 
                    y)\)]\) \[DifferentialD]z + \
\[Integral]\_\(1/2\)\%2\([\(\(\[Integral]\[Integral]\)\+\(A\_z\)\) \(x\^2\) \
\[DifferentialD]\((x, y)\)]\) \[DifferentialD]z\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(La\ integrales\ dobles\ anteriores\ puedes\ calcularlas\ pasando\ a\ \
coordenadas\ polares . \ \ Concretamente, \ 
    para\ la\ primera\ puedes\ hacer\ el\ cambio\ x = \ \
\[Rho]\ \ Cos[\[Theta]], \ 
    y = \ \(\(\[Rho]\)\(\ \ \)\(Sin[\[Theta]] . \ 
          El\)\(\ \)\(determinante\)\(\ \)\(jacobiano\)\(\ \)\(del\)\(\ \
\)\(cambio\)\(\ \)\(es\)\(\ \)\)\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\[Rho], \ con\ lo\ que\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\[Integral]\_0\%\(1/2\)\([\(\(\[Integral]\[Integral]\)\+\(A\_z\)\) \
\(x\^2\) \[DifferentialD]\((x, 
                  y)\)]\) \[DifferentialD]z = \[Integral]\_0\%\(1/2\)\([\
\[Integral]\_\(-\[Pi]\)\%\[Pi]\([\[Integral]\_0\%\(\(\@3\) z\)\(\[Rho]\^3\) 
                      Cos[\[Theta]]\^2\ \[DifferentialD]\[Rho]]\) \
\[DifferentialD]\[Theta]]\) \[DifferentialD]z\)], "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
De forma an\[AAcute]loga puedes calcular la otra integral. Hazlo para obtener \
la integral pedida.\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[{
    \(Calcula\ ahora\ la\ integral\ pedida\ proyectando\ primero\ el\ \
conjunto\ A\ sobre\ el\ plano\ XY\ y\ describiendo\ el\ intervalo\ de\ \
variaci\[OAcute]n\ de\ z\ para\ cada\ \((x, y)\) 
        en\ dicha\ proyecci\[OAcute]n . \ 
          F\[IAcute]jate\ que\ la\ proyecci\[OAcute]n\ de\ \ A\ sobre\ el\ \
plano\ XY\ \ es\ el\ disco\ unidad\ \ D = {\((x, y)\) : 
              x\^2 + y\^2 \[LessEqual] 1} . \ Si\ fijamos\ un\ punto\ \((x, 
          y)\) \[Epsilon]\ D, \ entonces\ si\ x\^2 + y\^2 \[LessEqual] 3/4, \ 
    z\ var\[IAcute]a\ en\ el\ intervalo\ que\ va\ de\ 1/\@3\ \ \@\(x^2 + \
y^2\)\ \ a\ \ 1 + \@\(1 - x\^2 - y\^2\)\ \((desde\ el\ cono\ hasta\ la\ parte\
\ superior\ de\ la\ esfera)\); \ 
    y\ si\ 3/4 \[LessEqual] \ x\^2 + y\^2 \[LessEqual] 
      1, \ \(\(z\)\(\ \)\(var\[IAcute]a\)\(\ \)\(en\)\(\ \)\(el\)\(\ \
\)\(intervalo\)\(\ \)\(que\)\(\ \)\(va\)\(\ \)\(de\)\(\ \ \)\)\), "\
\[IndentingNewLine]", 
    \(1 - \@\(1 - x\^2 - y\^2\)\ \ a\ \ 1 + \ \@\(1 - x\^2 - y\^2\)\ \((entre\
\ la\ parte\ superior\ e\ inferior\ de\ la\ esfera)\) . \ 
          Representando\ por\ D \((0, \@3\/2)\)\ el\ disco\ de\ centro\ 0\ y\ \
radio\ \@3\/2, \ 
    y\ por\ A \((0, \@3\/2, 1)\)\ el\ anillo\ de\ radios\ \@3\/2\ \ y\ \ 1, \ 
    la\ integral\ puedes\ calcularla, \ \(\(como\)\(:\)\)\)}], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(\(\(\(\[Integral]\[Integral]\)\+\(D \((0, \@3/2)\)\)[\[Integral]\_\(\(\ \
\)\(\(1\/\@3\) \@\(x\^2 + y\^2\)\)\)\%\(\(1\)\(+\)\(\@\(1 - x\^2 - y\^2\)\)\(\
\ \)\)\(x\^2\) \[DifferentialD]z] \[DifferentialD]\((x, 
              y)\) + \(\[Integral]\[Integral]\)\+\(A \((0, \@3/2, 1)\)\)[\
\[Integral]\_\(\(\ \)\(1 - \@\(1 - x\^2 - y\^2\)\)\)\%\(\(1\)\(+\)\(\@\(1 - x\
\^2 - y\^2\)\)\(\ \)\)\(x\^2\) \[DifferentialD]z] \[DifferentialD]\((x, 
              y)\) = \(\(\[Integral]\[Integral]\)\+\(D \((0, \@3/
                    2)\)\)\) \(x\^2\) \((1 + \@\(1 - x\^2 - y\^2\)\  - \
\(1\/\@3\) \@\(\(x\^2\)\(+\)\(y\^2\)\(\ \)\))\) \[DifferentialD]\((x, 
              y)\) + \(\(\[Integral]\[Integral]\)\+\(A \((0, \@3/2, 1)\)\)\) 
          2\ \(x\^2\) \(\@\(1 - x\^2 - y\^2\)\) \[DifferentialD]\((x, 
              y)\)\)\(\ \)\(\[IndentingNewLine]\)
    \)\)], "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
Utiliza coordenadas polares (con un cambio de escala) para calcular estas \
integrales. Comprueba que obtienes el mismo resultado que antes. \
\>", "Text",
  FontFamily->"Times New Roman"],

Cell["\<\
Finalmente, calcula directamente usando coordenadas esf\[EAcute]ricas, la \
integral pedida. Recuerda que las coordenadas esf\[EAcute]ricas vienen dadas \
por
x=\[Rho] Cos[\[Theta]] Sin[\[Phi]], y=\[Rho] Sin[\[Theta]] Sin[\[Phi]], z=\
\[Rho] Cos[\[Phi]]. Tenemos que:\
\>", "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(B = \({\((\[Rho], \[Theta], \[Phi])\) : \((\[Rho]\ Cos[\[Theta]]\ Sin[\
\[Phi]], \[Rho]\ Sin[\[Theta]]\ Sin[\[Phi]], \[Rho]\ Cos[\[Phi]])\) \
\[Element] A} = \({\((\[Rho], \[Theta], \[Phi])\) : \ \[Rho] \[LessEqual] 
                2\ Cos[\[Phi]], 
            3\ \ Cos[\[Phi]]\^2 \[GreaterEqual] \ \ Sin[\[Phi]]\^2} = \({\((\
\[Rho], \[Theta], \[Phi])\) : \(-\[Pi]\) \[LessEqual] \[Theta] \[LessEqual] \
\[Pi], \ \[Rho] \[LessEqual] 2\ Cos[\[Phi]], 
              Tan[\[Phi]] \[LessEqual] \ \ 1/\@3} = {\((\[Rho], \[Theta], \
\[Phi])\) : \(-\[Pi]\) \[LessEqual] \[Theta] \[LessEqual] \[Pi], \ \[Rho] \
\[LessEqual] 2\ Cos[\[Phi]], 
              0 \[LessEqual] \[Phi] <= \[Pi]/3}\)\)\)\)], "Text",
  FontFamily->"Times New Roman"],

Cell[BoxData[
    \(El\ determinante\ jacobiano\ de\ la\ transformaci\[OAcute]n\ es\ \((en\ \
valor\ absoluto)\)\ \(\[Rho]\^2\) Sin[\[Phi]] . \ Con\ ello, \ 
    la\ integral\ pedida\ es\ igual\ \(a : \
\[IndentingNewLine]\[Integral]\_\(-\[Pi]\)\%\[Pi]\([\[Integral]\_0\%\(\[Pi]/3\
\)\([\[Integral]\_0\%\(2  Cos[\[Phi]]\)\(\((\[Rho]\ Cos[\[Theta]]\ \
Sin[\[Phi]])\)\^2\) \(\[Rho]\^2\) 
                        Sin[\[Phi]] \[DifferentialD]\[Rho]]\) \
\[DifferentialD]\[Phi]]\) \[DifferentialD]\[Theta]\)\)], "Text",
  FontFamily->"Times New Roman"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1536}, {0, 862}},
WindowSize->{792, 500},
WindowMargins->{{-6, Automatic}, {Automatic, 3}},
PrintingCopies->1,
PrintingPageRange->{1, 1},
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 57, 1, 30, "Input"],
Cell[1814, 54, 596, 18, 52, "Text"],
Cell[2413, 74, 424, 15, 33, "Text"],
Cell[2840, 91, 1612, 29, 260, "Input"],

Cell[CellGroupData[{
Cell[4477, 124, 131, 3, 34, "Input"],
Cell[4611, 129, 82, 1, 49, "Output"]
}, Open  ]],
Cell[4708, 133, 696, 19, 52, "Text"],

Cell[CellGroupData[{
Cell[5429, 156, 136, 3, 34, "Input"],
Cell[5568, 161, 82, 1, 49, "Output"]
}, Open  ]],
Cell[5665, 165, 355, 10, 33, "Text"],
Cell[6023, 177, 122, 4, 33, "Text"],
Cell[6148, 183, 283, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[6456, 191, 75, 1, 30, "Input"],
Cell[6534, 194, 55, 1, 45, "Output"]
}, Open  ]],
Cell[6604, 198, 249, 8, 33, "Text"],
Cell[6856, 208, 340, 10, 33, "Text"],
Cell[7199, 220, 554, 8, 94, "Input"],

Cell[CellGroupData[{
Cell[7778, 232, 129, 3, 34, "Input"],
Cell[7910, 237, 59, 1, 42, "Output"]
}, Open  ]],
Cell[7984, 241, 213, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[8222, 250, 109, 2, 31, "Input"],
Cell[8334, 254, 59, 1, 42, "Output"]
}, Open  ]],
Cell[8408, 258, 128, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[8561, 265, 104, 2, 34, "Input"],
Cell[8668, 269, 113, 2, 45, "Output"]
}, Open  ]],
Cell[8796, 274, 104, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[8925, 281, 110, 2, 30, "Input"],
Cell[9038, 285, 106, 2, 45, "Output"]
}, Open  ]],
Cell[9159, 290, 145, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[9329, 297, 73, 1, 30, "Input"],
Cell[9405, 300, 59, 1, 42, "Output"]
}, Open  ]],
Cell[9479, 304, 688, 21, 63, "Text"],
Cell[10170, 327, 476, 8, 94, "Input"],
Cell[10649, 337, 57, 1, 30, "Input"],
Cell[10709, 340, 350, 6, 52, "Input"],

Cell[CellGroupData[{
Cell[11084, 350, 138, 3, 34, "Input"],
Cell[11225, 355, 68, 1, 45, "Output"]
}, Open  ]],
Cell[11308, 359, 62, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[11395, 363, 244, 4, 31, "Input"],
Cell[11642, 369, 68, 1, 45, "Output"]
}, Open  ]],
Cell[11725, 373, 573, 19, 33, "Text"],
Cell[12301, 394, 532, 15, 33, "Text"],
Cell[12836, 411, 647, 11, 115, "Input"],

Cell[CellGroupData[{
Cell[13508, 426, 148, 3, 34, "Input"],
Cell[13659, 431, 66, 1, 45, "Output"]
}, Open  ]],
Cell[13740, 435, 83, 1, 33, "Text"],

Cell[CellGroupData[{
Cell[13848, 440, 128, 2, 31, "Input"],
Cell[13979, 444, 66, 1, 45, "Output"]
}, Open  ]],
Cell[14060, 448, 411, 11, 39, "Text"],
Cell[14474, 461, 1032, 34, 60, "Text"],
Cell[15509, 497, 137, 2, 53, "Input"],
Cell[15649, 501, 705, 11, 110, "Input"],
Cell[16357, 514, 911, 22, 114, "Text"],
Cell[17271, 538, 657, 10, 114, "Input"],
Cell[17931, 550, 1019, 22, 134, "Text"],

Cell[CellGroupData[{
Cell[18975, 576, 124, 2, 31, "Input"],
Cell[19102, 580, 59, 1, 42, "Output"]
}, Open  ]],
Cell[19176, 584, 136, 2, 34, "Text"],
Cell[19315, 588, 125, 2, 53, "Input"],

Cell[CellGroupData[{
Cell[19465, 594, 125, 3, 34, "Input"],
Cell[19593, 599, 297, 5, 45, "Output"]
}, Open  ]],
Cell[19905, 607, 565, 13, 74, "Text"],

Cell[CellGroupData[{
Cell[20495, 624, 239, 5, 56, "Input"],
Cell[20737, 631, 59, 1, 42, "Output"]
}, Open  ]],
Cell[20811, 635, 1016, 26, 51, "Text"],
Cell[21830, 663, 284, 5, 74, "Input"],

Cell[CellGroupData[{
Cell[22139, 672, 122, 2, 31, "Input"],
Cell[22264, 676, 69, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22370, 682, 163, 5, 73, "Section"],
Cell[22536, 689, 655, 16, 54, "Text"],
Cell[23194, 707, 374, 10, 52, "Text"],

Cell[CellGroupData[{
Cell[23593, 721, 179, 4, 31, "Input"],
Cell[23775, 727, 271, 4, 72, "Output"]
}, Open  ]],
Cell[24061, 734, 423, 7, 54, "Text"],
Cell[24487, 743, 190, 4, 52, "Text"],
Cell[24680, 749, 833, 15, 190, "Input"],
Cell[25516, 766, 786, 14, 91, "Text"],
Cell[26305, 782, 446, 8, 64, "Text"],
Cell[26754, 792, 424, 8, 50, "Text"],
Cell[27181, 802, 87, 2, 31, "Text"],
Cell[27271, 806, 430, 7, 64, "Text"],
Cell[27704, 815, 156, 4, 33, "Text"],
Cell[27863, 821, 1368, 22, 239, "Text"],
Cell[29234, 845, 917, 14, 167, "Text"],
Cell[30154, 861, 198, 4, 33, "Text"],
Cell[30355, 867, 324, 7, 52, "Text"],
Cell[30682, 876, 752, 12, 55, "Text"],
Cell[31437, 890, 547, 9, 66, "Text"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

